/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.bristol.star.feather.Buf;
import uk.ac.bristol.star.feather.BufAccess;

public class BufMapper {
    private final FileChannel channel_;
    private final long start_;
    private final long length_;
    private static final FileChannel.MapMode RO_MODE = FileChannel.MapMode.READ_ONLY;

    public BufMapper(FileChannel fileChannel, long l, long l2) {
        this.channel_ = fileChannel;
        this.start_ = l;
        this.length_ = l2;
    }

    public long getStart() {
        return this.start_;
    }

    public long getLength() {
        return this.length_;
    }

    public Buf mapBuffer() throws IOException {
        return this.mapBuffer(0L, this.length_);
    }

    public Buf mapBuffer(long l, long l2) throws IOException {
        long l3 = this.start_ + l;
        BufAccess bufAccess = l2 < Integer.MAX_VALUE ? new SimpleAccess(this.channel_, l3, l2) : new MultiAccess(this.channel_, l3, l2);
        return new Buf(bufAccess);
    }

    private static class MultiAccess
    implements BufAccess {
        private final FileChannel channel_;
        private final long offset_;
        private final long leng_;
        private final int pow2_;
        private final long bankSize_;
        private final int mask_;
        private final ByteBuffer[] bbufs_;

        public MultiAccess(FileChannel fileChannel, long l, long l2, int n) {
            if (n < 1 || n > 31) {
                throw new IllegalArgumentException("Bad pow2: " + n);
            }
            this.channel_ = fileChannel;
            this.offset_ = l;
            this.leng_ = l2;
            this.pow2_ = n;
            this.bankSize_ = 1L << this.pow2_;
            this.mask_ = (int)this.bankSize_ - 1;
            this.bbufs_ = new ByteBuffer[this.bankIndex(l2) + 1];
        }

        public MultiAccess(FileChannel fileChannel, long l, long l2) {
            this(fileChannel, l, l2, 30);
        }

        @Override
        public byte get(long l) {
            return this.getByteBuffer(this.bankIndex(l)).get(this.bankOffset(l));
        }

        public ByteBuffer getByteBuffer(int n) {
            MappedByteBuffer mappedByteBuffer;
            ByteBuffer byteBuffer = this.bbufs_[n];
            if (byteBuffer != null) {
                return byteBuffer;
            }
            long l = this.offset_ + (long)n * this.bankSize_;
            long l2 = Math.min(this.bankSize_, this.leng_ - (long)n * this.bankSize_);
            try {
                mappedByteBuffer = this.channel_.map(RO_MODE, l, l2);
            }
            catch (IOException iOException) {
                throw new RuntimeException("File mapping failure: " + iOException, iOException);
            }
            this.bbufs_[n] = mappedByteBuffer;
            return mappedByteBuffer;
        }

        private int bankIndex(long l) {
            return (int)(l >> this.pow2_);
        }

        private int bankOffset(long l) {
            return (int)l & this.mask_;
        }
    }

    private static class SimpleAccess
    implements BufAccess {
        private final ByteBuffer bbuf_;

        public SimpleAccess(FileChannel fileChannel, long l, long l2) throws IOException {
            this.bbuf_ = fileChannel.map(RO_MODE, l, l2);
        }

        @Override
        public byte get(long l) {
            return this.bbuf_.get(SimpleAccess.longToInt(l));
        }

        private static int longToInt(long l) {
            return (int)l;
        }
    }
}

