/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class BufUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private BufUtils() {
    }

    public static int readLittleEndianInt(RandomAccessFile randomAccessFile) throws IOException {
        return (randomAccessFile.read() & 0xFF) << 0 | (randomAccessFile.read() & 0xFF) << 8 | (randomAccessFile.read() & 0xFF) << 16 | (randomAccessFile.read() & 0xFF) << 24;
    }

    public static void writeLittleEndianLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l >> 0) & 0xFF);
        outputStream.write((int)(l >> 8) & 0xFF);
        outputStream.write((int)(l >> 16) & 0xFF);
        outputStream.write((int)(l >> 24) & 0xFF);
        outputStream.write((int)(l >> 32) & 0xFF);
        outputStream.write((int)(l >> 40) & 0xFF);
        outputStream.write((int)(l >> 48) & 0xFF);
        outputStream.write((int)(l >> 56) & 0xFF);
    }

    public static void writeLittleEndianInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 0 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    public static void writeLittleEndianShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s >> 0 & 0xFF);
        outputStream.write(s >> 8 & 0xFF);
    }

    public static void writeLittleEndianDouble(OutputStream outputStream, double d) throws IOException {
        BufUtils.writeLittleEndianLong(outputStream, Double.doubleToLongBits(d));
    }

    public static void writeLittleEndianFloat(OutputStream outputStream, float f) throws IOException {
        BufUtils.writeLittleEndianInt(outputStream, Float.floatToIntBits(f));
    }

    public static int align8(OutputStream outputStream, long l) throws IOException {
        int n;
        int n2 = (int)l & 7;
        if (n2 > 0) {
            n = 8 - n2;
            for (int i = 0; i < n; ++i) {
                outputStream.write(0);
            }
        } else {
            n = 0;
        }
        return n;
    }

    public static long ceil8(long l) {
        return (l + 7L) / 8L * 8L;
    }

    public static int utf8Length(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                ++n;
                continue;
            }
            if (c <= '\u07ff') {
                n += 2;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                n += 4;
                ++i;
                continue;
            }
            n += 3;
        }
        assert (n == string.getBytes(UTF8).length);
        return n;
    }
}

